<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
function paginate(
    string $base_url,
    string $query_str,
    int $total_pages,
    int $current_page,
    int $paginate_limit
): array {
    // Array to store page link list
    $page_array = [];
    
    // Show dots flag - where to show dots?
    $dotshow = true;
    
    // walk through the list of pages
    for ($i = 1; $i <= $total_pages; $i++) {
        // If first or last page or the page number falls
        // within the pagination limit
        // generate the links for these pages
        if ($i == 1 || $i == $total_pages || 
            ($i >= $current_page - $paginate_limit && 
             $i <= $current_page + $paginate_limit)) {
                 
            // reset the show dots flag
            $dotshow = true;

            // If it's the current page, leave out the link
            // otherwise set a URL field also
            $c = $i - 1;
            $page_array[$i]['url'] = $base_url . "?" . $query_str . "=" . $c;
            $page_array[$i]['text'] = strval($i);
        } 
        // If ellipses dots are to be displayed
        // (page navigation skipped)
        else if ($dotshow === true) {
            // set it to false, so that more than one
            // set of ellipses is not displayed
            $dotshow = false;
            $page_array[$i]['text'] = "...";
        }
    }
    
    // return the navigation array
    return $page_array;
}

function limit_load(
    array $contents = [], 
    int $load = 0, 
    int $showlim = 1, 
    int $min = 0, 
    int $max = 1
): array {
  
    $output = [];
    $i = 1;
    $countval = 1;
    $counter = 0;
    $maxval = $showlim;

    if ($load > 0) {
        $maxval = $max;
    }

    $minval = $min;
    $loadval = $load + 1;

    if ($loadval >= 2) {
        $countval = $maxval;
        $minval = ($maxval * $loadval) - $maxval;
        $maxval = ($maxval * $loadval);
    }

    foreach ($contents as $content) {
        if ($i > $minval) {
            if ($i > $maxval) {
                continue;
            }
            $output[] = $content;
        }

        if (count($contents) === $i) {
       //     $output['stopmoreload'] = '<div id="stopmoreload"></div>';
        }

        $i++;
    }

    return $output;
}
?>