<div class="control-panel rel">

    <?php
    $submitted = true;
    $timeclocks = get_today_clocks();
    $brakes = get_today_breaks();
    if(!timecard_today_submitted()){
        $submitted = false;
        ?>
    <div id="control-submit-view">
    <div class="control-wrap">
            <div class="control-group">
                <?php
                if(!is_clocked_in()) { ?>
                    <a id="clock-in-btn" href="timecards/?action=clock-in" class="button bg-green color-white wide ajax-anchor" data-refresh=".control-panel">Clock-In</a>
                <?php }else {
                    ?>
                    <a id="clock-out-btn" href="" class="<?php echo is_on_break() ?'disabled':'' ?> button bg-red color-white wide">Clock-Out</a>
                    <?php
                }?>
                <div class="space2"></div>

                <?php foreach($timeclocks as $clock){
                    ?>
                    <div class="row color-gray">
                        <div class="col-md-6"><label>Clock in:</label> <div class="clock-time"><?php echo get_clock_time($clock['clock_in'])?></div></div>
                        <div class="col-md-6 text-right"><label>Clock out:</label> <div class="clock-time"><?php echo get_clock_time($clock['clock_out']) ?></div></div>
                    </div>
                    <div class="space2"></div>
                <?php }?>
            </div>
        <hr>

            <div <?php echo !is_clocked_in() ? 'title="Clock-in to enable actions"' : '' ?>>
        <div class="control-group <?php echo !is_clocked_in() ? 'disabled overlay' : '' ?>">
            <label class="color-gray">1. Breaks:</label>
            <div class="space2"></div>
            <div class="row color-gray">
                    <?php if(!is_on_break()){ ?>
                <div class="col-md-12"><a href="timecards?action=break-in" class="button bg-orange color-white wide ajax-anchor" data-refresh=".control-panel">On break</a>
                    <div class="space2"></div></div>
                    <div class="col-md-12"><a href="" class="disabled button bg-lightgray color-white wide">Off break</a></div>
                    <?php }else {
                    ?>
                    <div class="col-md-12"><a href="" class="button bg-gray disabled color-white wide">On break</a>
                        <div class="space2"></div></div>
                        <div class="col-md-12"><a href="timecards?action=break-out" class="button bg-lightgreen color-white wide ajax-anchor" data-refresh=".control-panel">Off break</a></div>
                    <?php
                    }?>
            </div>

            <div class="space2"></div>
            <?php
            foreach($brakes as $break){
                ?>
                <div class="row color-gray">
                    <div class="col-md-6"><div><label>On break:</label> <div class="clock-time"><?php echo get_clock_time($break['break_in']) ?></div></div></div>
                    <div class="col-md-6 text-right"><div><label>Off break:</label> <div class="clock-time"><?php echo get_clock_time($break['break_out'])  ?></div></div></div>
                </div>
                <div class="space1"></div>
            <?php }?>

            </div>
            </div>

        <?php if(is_clocked_in()){

            ?>
        <hr>

        <div <?php echo is_on_break() ? 'title="Actions are disabled while you\'re on break."':'' ?>>
        <div <?php echo is_on_break() ? 'class="disabled overlay" title="Actions disabled while you\'re on break."':'' ?>>



            <div class="control-group">
                <div class="space1"></div>
                <div class="row">
                    <div class="col-md-6">
                        <label class="color-gray">2. Upload progress:</label>
                    </div>
                    <div class="col-md-6 text-right">
                        <a id="job-upload-btn" class="color-gray div-toggle" data-target="#job-upload-area .upload-input-area"><i class="icon-plus"><?php echo file_get_contents('images/icon-plus.svg');?></i></a>
                    </div>
                </div>
                <form class="form">
                    <div id="job-upload-area" class="row">
                        <div class="col-md-12">
                            <div class="upload-input-area hidden">
                                <div>
                                    <div class="space1"></div>

                                    <div class="form-group">
                                        <select id="emp_job_no" name="job_no" class="form-control">
                                            <?php
                                            $d = date('Y-m-d');
                                            $job_ids = mysqli_query($conn,"SELECT job.id, job_no, job_title FROM job INNER JOIN timeplan ON timeplan.job_id=job.id WHERE timeplan.emp_id=$u_id AND timeplan.phase_start_date='$d' GROUP BY job_no");
                                            if($job_ids->num_rows){
                                                while($jid=mysqli_fetch_array($job_ids)) {
                                                    ?>
                                                    <option name="<?php echo $jid['job_title'] ?>" value="<?php echo $jid['job_no'] ?>" data-id="<?php echo $jid['id'] ?>"><?php echo $jid['job_title'] ?></option>
                                                <?php }
                                            }?>
                                        </select>
                                    </div>

                                </div>

                                <div class="draggable-uploads">
                                    <input type="file" multiple name="job_uploads" accept=".jpg, .png, .gif, .pdf, .doc, .docx">
                                </div>
                                <div class="uploads-view">
                                    <label>Uploads:</label>
                                    <div class="append-list"></div>
                                    <div class="space1"></div>
                                    <button type="button" name="upload_files" class="button wide bg-black color-white">Upload</button>
                                </div>
                            </div>

                            <div class="job-file-list-view"> </div>
                        </div>

                    </div>
                </form>
            </div>

            <hr>

            <div class="control-group">
                <div class="space1"></div>
                <div class="row">
                    <div class="col-md-12">
                        <label class="color-gray"> <a class="color-gray hover-green div-toggle" data-target="#job-notes"><i class="icon-plus"><?php echo file_get_contents('images/icon-plus.svg');?></i> &nbsp; Add notes</a></label>
                    </div>
                    <div id="job-notes" class="hidden col-md-12">
                        <div class="space1"></div>
                        <textarea class="form-control" onblur="$('.timecard-note-text').val(this.value).text(this.value)" rows="4" placeholder="Add Note"></textarea>
                    </div>
                </div>
            </div>

        </div>
         </div>

        <?php }?>

    </div>
    </div>
    <?php }
    ?>

    <div id="control-summary-view" class="<?php echo !$submitted ? 'hide':'' ?>">
        <?php
        if($submitted) {
            $get_data = get_today_timeclock_data();
        }else {
            $get_data = [
              'note'=>''
            ];
        }
        ?>
        <form method="post" action="">
            <div class="control-group">
                <a class="button wide disabled"><?php echo !$submitted ? 'Clock-Out':'Timecard submitted' ?></a>

                <?php
                if(!empty($timeclocks)){
                ?>
                <div class="space4"></div>
                <?php foreach($timeclocks as $clock){
                    ?>

                    <div class="row time-row color-gray">
                        <div class="col-md-6"><label>Clock in:</label> <div class="clock-time"><?php echo get_clock_time($clock['clock_in'])?></div></div>
                        <div class="col-md-6 text-right"><label>Clock out:</label> <div class="clock-time"><?php echo get_clock_time($clock['clock_out']) ?></div></div>
                    </div>
                <?php }
                }?>
            </div>
            <hr>
            <div class="control-group">
                <label class="color-gray">1. Breaks:</label>
                <div class="space2"></div>
                <?php

                if(!empty($brakes)){
                    foreach($brakes as $break){
                        ?>
                        <div class="row time-row color-gray">
                            <div class="col-md-6">
                                <input type="hidden" name="breaks[]" value="<?php echo $break['break_id'] ?>">
                                <div><label>On break:</label> <div class="clock-time"><?php echo get_clock_time($break['break_in']) ?></div></div></div>
                            <div class="col-md-6 text-right"><div><label>Off break:</label> <div class="clock-time"><?php echo get_clock_time($break['break_out'])  ?></div></div></div>
                        </div>
                        <div class="space1"></div>
                    <?php }
                }else {
                    echo 'No breaks';
                }?>

            </div>
            <hr>

            <div class="control-group">
                <div class="space1"></div>
                <div class="row">
                    <div class="col-md-6">
                        <label class="color-gray">2. Upload progress:</label>
                    </div>
                    <div class="col-md-6 text-right">
                    </div>
                </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="job-file-list-view job-file-list-inputs">
                            </div>
                        </div>
                    </div>
            </div>


            <hr>

            <div class="control-group">
                <div class="space1"></div>
                <div class="row">
                    <div class="col-md-12">
                        <label class="color-gray">Notes</label>
                    </div>
                    <div class="col-md-12">
                        <div class="space1"></div>
                        <p class="timecard-note-text"><?php echo $get_data['note'] ?></p>
                        <input hidden type="hidden" class="timecard-note-text" name="note" value="">
                    </div>
                </div>
            </div>

            <?php if(!$submitted){ ?>
            <hr>

            <div class="control-group">
                <div class="space1"></div>
                <div class="row">
                    <div class="col-md-12">
                        <input type="hidden" name="action" value="submit-timecard">
                        <button type="submit" onclick="$(this).addClass('disabled')" class="border-green bg-transparent color-green button wide slim">Submit timecard</button>
                    </div>
                </div>
            </div>
            <?php }else {
                ?>
                <hr>

                <div class="control-group">
                    <div class="space1"></div>
                    <div class="row">
                        <div class="col-md-12">
                            <a href="timecards/view-timecards.php" class="border-green bg-transparent color-green button wide slim">View Timecards</a>
                        </div>
                    </div>
                </div>
            <?php
            }?>
        </form>
    </div>

</div>