<?php
$username = $designation = '';
$u_id = (int)$_SESSION['employee'];
function pre($arr) {
    echo '<pre>';
    print_r($arr);
    echo '</pre>';
}

//Debug PHP
if(!function_exists('php_error')) {
    function php_error()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        error_reporting(-1);
    }
}

if(!empty($_SESSION['employee'])) {
    $db = mysqli_query($conn,"SELECT name,designation FROM employee WHERE emp_id=$u_id");
    $arr = mysqli_fetch_assoc($db);
    $username = $arr['name'];
    $designation = $arr['designation'];
}

function run_query($query="",$single=false) {
    global $conn;
    $q = mysqli_query($conn,$query) or die('Fetch error');
    $output = [];
    if($q->num_rows) {
        if(!$single) {
            while ($arr = mysqli_fetch_array($q)) {
                $output[] = $arr;
            }
        }else {
            return mysqli_fetch_array($q);
        }
    }
    return $output;
}

function get_clock_id() {
    global $conn, $u_id;
    $date = date('Y-m-d');
    $db = mysqli_query($conn,"SELECT log_id FROM employee_clock_log WHERE emp_id=$u_id AND DATE_FORMAT(record_date,'%Y-%m-%d')='$date' AND status=1");
    if($db->num_rows) {
        $res = mysqli_fetch_assoc($db);
        return $res['log_id'];
    }
    return 0;
}

function clock_in_time() {
    $output = '--:--';
    global $conn, $u_id;
    $date = date('Y-m-d');
    $db = mysqli_query($conn,"SELECT clock_in,record_date FROM employee_clock_log WHERE emp_id=$u_id AND DATE_FORMAT(record_date,'%Y-%m-%d')='$date'");

    if($u_id && $db->num_rows) {
        $arr = mysqli_fetch_assoc($db);
        $output = !empty($arr['clock_in']) && $arr['clock_in'] !== '00:00:00' ? get_clock_time($arr['clock_in']) : '--:--';
    }
    return $output;
}

function clock_out_time() {
    $output = '--:--';
    global $conn, $u_id;
    $date = date('Y-m-d');
    $db = mysqli_query($conn,"SELECT clock_out,record_date FROM employee_clock_log WHERE emp_id=$u_id AND DATE_FORMAT(record_date,'%Y-%m-%d')='$date'");
    if($u_id && $db->num_rows) {
        $arr = mysqli_fetch_assoc($db);
        $output = $arr['clock_out'] !== '00:00:00' ? get_clock_time($arr['clock_out']) :'--:--';
    }
    return $output;
}

function is_clocked_in() {
    global $conn, $u_id;
    $date = date('Y-m-d');
    $db = mysqli_query($conn,"SELECT clock_out,record_date FROM employee_clock_log WHERE emp_id=$u_id AND status=1 AND DATE_FORMAT(record_date,'%Y-%m-%d')='$date'");

    if($db->num_rows) {
        return true;
    }
    return false;
}

function is_on_break() {
    $date = date('Y-m-d');
    $log_id = get_clock_id();
    global $conn, $u_id;

    $q = mysqli_query($conn,"SELECT break.break_id FROM employee_break_log AS break INNER JOIN employee_clock_log AS clock ON clock.log_id=break.log_id WHERE break.log_id=$log_id AND DATE_FORMAT(clock.record_date,'%Y-%m-%d')='$date' AND clock.emp_id=$u_id AND break.break_out='00:00:00'") or die('Break fetch error');

    $break_id = 0;
    if($q->num_rows) {
        $res = mysqli_fetch_assoc($q);
        $break_id = $res['break_id'];
    }

    return $break_id;
}

function get_clock_time($str) {
    return !empty($str) && $str != '00:00:00' ? date('h:i a',strtotime($str)) : '--:--';
}

function get_today_clocks() {
    $date = date('Y-m-d');
    global $conn, $u_id;

    $q = mysqli_query($conn,"SELECT clock.* FROM employee_clock_log AS clock WHERE DATE_FORMAT(clock.record_date,'%Y-%m-%d')='$date' AND clock.emp_id=$u_id") or die('Clock fetch error');

    $output = [];
    if($q->num_rows) {
        while($arr = mysqli_fetch_array($q)) {
            $output[] = $arr;
        }
    }
    return $output;
}

function get_today_breaks() {
    $date = date('Y-m-d');
    global $conn, $u_id;

    $q = mysqli_query($conn,"SELECT break.* FROM employee_break_log AS break INNER JOIN employee_clock_log AS clock ON clock.log_id=break.log_id WHERE DATE_FORMAT(clock.record_date,'%Y-%m-%d')='$date' AND clock.emp_id=$u_id") or die('Break fetch error');

    $output = [];
    if($q->num_rows) {
        while($arr = mysqli_fetch_array($q)) {
            $output[] = $arr;
        }
    }
    return $output;
}

function timecard_today_submitted() {
    global $conn, $u_id;
    $date = date('Y-m-d');

    $check = mysqli_query($conn, "SELECT log_id FROM employee_clock_log WHERE emp_id=$u_id AND status=0 AND DATE_FORMAT(record_date,'%Y-%m-%d')='$date'");
    if($check->num_rows) {
        return 1;
    }
    return 0;
}

function get_timecards_data($select="*") {
    global $conn, $u_id;
    $output = [];
    $sql = "SELECT $select FROM employee_clock_log WHERE emp_id=$u_id AND status=0";
    if(!empty($_GET['month'])) {
        $month = (int)$_GET['month'];
        $sql .= " AND MONTH(record_date)=$month";
    }
    if(!empty($_GET['date-range'])) {
        $date = explode('-',$_GET['date-range']);
        $d0 = explode('/',trim($date[0]));
        $d0 = $d0[2].'-'.$d0[0].'-'.$d0[1];

        $d1 = explode('/',trim($date[1]));
        $d1 = $d1[2].'-'.$d1[0].'-'.$d1[1];
        $sql .= " AND record_date BETWEEN DATE('".$d0."') AND DATE('".$d1."')";
    }
    $check = mysqli_query($conn, $sql);
    if($check->num_rows) {
        while($arr = mysqli_fetch_array($check)) {
            $output[] = $arr;
        }
    }
    return $output;
}

function get_today_timeclock_data() {
    global $conn, $u_id;
    $date = date('Y-m-d');
    $output = [];
    $check = mysqli_query($conn, "SELECT * FROM employee_clock_log WHERE emp_id=$u_id AND DATE_FORMAT(record_date,'%Y-%m-%d')='$date'");
    if($check->num_rows) {
        $output = mysqli_fetch_assoc($check);
    }
    return $output;
}

function get_file_size($bytes) {
    if ($bytes >= 1073741824)
    {
        $bytes = number_format($bytes / 1073741824, 2) . ' GB';
    }
    elseif ($bytes >= 1048576)
    {
        $bytes = number_format($bytes / 1048576, 2) . ' MB';
    }
    elseif ($bytes >= 1024)
    {
        $bytes = number_format($bytes / 1024, 2) . ' KB';
    }
    elseif ($bytes > 1)
    {
        $bytes = $bytes . ' bytes';
    }
    elseif ($bytes == 1)
    {
        $bytes = $bytes . ' byte';
    }
    else
    {
        $bytes = '0 bytes';
    }

    return $bytes;
}

function time_difference($time1, $time2) {
    $in = new DateTime($time1);
    $out = new DateTime($time2);
    $time_diff = $in->diff($out);

    $zerodate = new DateTime('0000-01-01 00:00:00');
    $zerodate->add($time_diff);

    return $zerodate;
}

function valid_mime($fileinput,$mimes=[]) {
    if(!is_array($_FILES[$fileinput]['tmp_name'])) {
        $mimetype = mime_content_type($_FILES[$fileinput]['tmp_name']);
        if (in_array($mimetype, $mimes)) {
            return true;
        }
    }else {
        foreach($_FILES[$fileinput]['tmp_name'] as $tmp_name) {
            $mimetype = mime_content_type($tmp_name);
            if (!in_array($mimetype, $mimes)) {
                return false;
            }
        }
        return true;
    }
    return false;
}