<?php


    $get_total_works = run_query("SELECT log.log_id, log.clock_out, log.clock_in, (abs(TIMESTAMPDIFF(SECOND, log.clock_in, log.clock_out))) AS total_time, break.break_in, break.break_out, SUM(abs(TIMESTAMPDIFF(SECOND, break.break_in, break.break_out))) AS break_time FROM employee_clock_log AS log LEFT JOIN employee_break_log AS break ON FIND_IN_SET(break.break_id,log.breaks) WHERE log.status=0 GROUP BY log.log_id");

    $total_work_secs = '';
    $total_break_secs = '';
    foreach($get_total_works as $get_total_work) {
        $total_work_secs += (int)$get_total_work['total_time'];
        $total_break_secs += (int)$get_total_work['break_time'];
    }
    $total_work_secs -= $total_break_secs;

    $hours = floor($total_work_secs / 3600);
    $minutes = floor(($total_work_secs / 60) % 60);

    $work_time_text = [$hours,$minutes];

    $file_upload_count = 0;
    $get_work_files = mysqli_fetch_assoc(mysqli_query($conn,"SELECT COUNT(upload.job_id) as total_files FROM upload_dev AS upload JOIN employee_clock_log AS clock ON upload.clock_log_id=clock.log_id WHERE clock.status = 0"));

?>

<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />

<div class="timecard-filters">
    <form id="filter-form" method="get">
        <input type="hidden" name="filter" value="1">
        <div class="row">
            <div class="col-md-6">
                <div class="filter-month">
                    <select class="select2" name="month" onchange="this.form.submit()" value="<?php echo !empty($_GET['month']) ? $_GET['month']:0 ?>">
                        <option value="0" selected>All Months</option>
                        <?php
                        for($i=1; $i<=12; $i++) {
                            ?>
                            <option value="<?php echo $i ?>"><?php echo date("F", mktime(0, 0, 0, $i, 10)); ?></option>
                            <?php
                        } ?>
                    </select>
                </div>
                <div class="time-hours">
                    <label style="padding: 10px 5px;">Total hours: <span><?php echo $work_time_text[0].'h '.$work_time_text[1].'m' ?></span></label>

                </div>
                <div class="file-upload-count">
                    <label style="padding: 10px 5px;">Files uploaded: <span><?php echo $get_work_files['total_files']; ?></span> </label>
                </div>
            </div>
            <div class="col-md-6 text-right">
                <div class="filter-calender">
                    <input type="text" name="date-range" class="form-control">
                </div>
            </div>
        </div>
    </form>
</div>

<script>
    $(function() {
        $('input[name="date-range"]').daterangepicker({
            opens: 'left',
            placeholder: 'Filter by date',
            format: 'dd/mm/yyyy'
        }, function(start, end, label) {
            //console.log("A new date selection was made: " + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD'));
            setTimeout(()=>{
                document.getElementById('filter-form').submit();
            },50);

        });
        $('input[name="date-range"]').val('').attr('placeholder','Date range');
        $('input[name="date-range"]').on('blur', function() {
            const curr_date = new Date();
            const m = curr_date.getMonth()+1;
            const curr_month = m <= 9 ? '0'+m:m;
            const curr_day = curr_date.getDate() <= 9 ? '0'+curr_date.getDate():curr_date.getDate();
            const curr_year = curr_date.getFullYear();
            const str = curr_month+'/'+curr_day+'/'+curr_year+' - '+curr_month+'/'+curr_day+'/'+curr_year;

            console.log(this.value);
            console.log(str);

            if(this.value == str) {
                $(this).val('').attr('placeholder','Date range');
            }
        })
    });
</script>