<?php

include('actions.php');

if($_SESSION['userid']=='')
{
    header("Location: ../index.php");
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">

<head>

    <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />

    <title>Web Media</title>

    <base href="https://signumconcepts.com/signumdb/">

    <?php include('../includes/header.php');?>

    <link href="timecards/css/timecards.css" rel="stylesheet" type="text/css" />

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script type="application/javascript" src="timecards/js/sweetalert2.all.min.js"></script>

    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

</head>

<body>

<?php

$page = basename($_SERVER['PHP_SELF']);

?>

<link href="https://code.jquery.com/ui/1.10.3/themes/redmond/jquery-ui.css" rel="stylesheet" media="screen">

<!-- Bootstrap -->
<link href="../css/bootstrap.min.css" rel="stylesheet">
<!-- styles -->
<link href="../css/styles.css" rel="stylesheet">

<link href="../styles.css" rel="stylesheet" type="text/css" />
<link href="../style.css" rel="stylesheet" type="text/css" />
<script type="text/javascript" src="../js/home.js"></script>
<script type="text/javascript" src="../js/ajax.js"></script>

<div id="topmenu">
    <div class="animatedtabs" >

        <ul>
            <li><a href="employee_profile.php" title="Home" class="<?= $page=='employee_profile.php' ? 'active' : ''?>">Home</a></li>
            <li><a href="employee_task_list.php" title="Today Tasks" class="<?= $page=='employee_task_list.php' ? 'active' : ''?>">Today's Task</a></li>
            <li><a href="emp_task.php" title="Task Sheet" class="<?= $page=='emp_task.php' ? 'active' : ''?>">Task Sheet</a></li>
            <li><a style="border:none !important" href="timecards/view-timecards.php" title="Timecards">Timecards</a></li>


        </ul>
    </div>
</div>


<div class="container">
    <br><br>
    <h2>TIME CARDS</h2>

    <div class="row">
        <div class="col-md-6">
            <p><strong>Employee Name:</strong> <?php echo $username ?></p>
            <p><strong>Designation:</strong> <?php echo $designation ?></p>
        </div>
        <div class="col-md-6 text-right">
            <div class="d-inline-block">
                <form action="search_top.php" method="post" name="search" id="search">
                    <div class="col-md-8 fl" style="padding-right: 0;"> <input class="form-control" name="jobno" type="text" id="penname"> </div>
                    <div class="col-md-2 fl">
                        <input class="btn-primary btn button" type="submit" name="Submit" value="Search">
                    </div>
                </form>
            </div>
        </div>
    </div>
    <br><br>
</div>

<script type="text/javascript">
    function start_time(url)
    {	//alert("hello");
        window.location=url;
    }
</script>
<style>
    .link:hover {
        cursor: pointer;
    }
    .link:hover svg g {
        fill: #DAC681;
    }
    .download-btn {
        display: inline-block;
        width: 20px;
        float: none;
        text-align: right;
        opacity: 0.5;
    }
    .file-list {
        display: flex;
        padding-top: 12px;
        opacity: 0.8;
    }
    .time-meta {
        font-size: 12px;
        line-height: 1;
        margin-bottom: 12px;
    }
    .job-file-list .file-icon {
        width: 14px;
        height: 100%;
        float: left;
        margin-right: 3px;
    }
    .job-file-list h3 {
        font-weight: 500;
        font-size: 12px !important;
        margin-bottom: 4px !important;
        margin-top: 18px !important;
    }
    .job-file-list p {
        margin-bottom: 10px !important;
    }
    .job-file-list .file-list:not(:last-child) {
        border-bottom: 1px solid #eee;
    }
    .job-file-list .file-list .file-size {
        font-size: 11px;
    }
    .job-file-list span.file-count {
        font-weight: 400;
        opacity: 0.8;
    }

</style>
<div class="container">
    <?php
    $folder_icon = '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 172 172"><g fill="none" fill-rule="nonzero" stroke="none" stroke-width="1" stroke-linecap="butt" stroke-linejoin="miter" stroke-miterlimit="10" stroke-dasharray="" stroke-dashoffset="0" font-family="none" font-weight="none" font-size="none" text-anchor="none" style="mix-blend-mode: normal"><path d="M0,172v-172h172v172z" fill="none"></path><g fill="#8c8c8c"><path d="M30.45833,28.66667c-8.84188,0 -16.125,7.28312 -16.125,16.125v82.41667c0,8.84188 7.28312,16.125 16.125,16.125h111.08333c8.84188,0 16.125,-7.28312 16.125,-16.125v-64.5c0,-8.84188 -7.28312,-16.125 -16.125,-16.125h-55.38769l-16.02002,-13.34652c-3.54109,-2.95009 -8.00196,-4.57015 -12.61166,-4.57015zM30.45833,39.41667h27.06396c2.0983,0 4.12019,0.73587 5.73194,2.07861l12.55566,10.46305l-12.55566,10.46305c-1.61174,1.34275 -3.63363,2.07861 -5.73194,2.07861h-32.43896v-19.70833c0,-3.03329 2.34171,-5.375 5.375,-5.375zM86.15397,57.33333h55.38769c3.03329,0 5.375,2.34171 5.375,5.375v64.5c0,3.03329 -2.34171,5.375 -5.375,5.375h-111.08333c-3.03329,0 -5.375,-2.34171 -5.375,-5.375v-51.95833h32.43896c4.6097,0 9.07057,-1.62006 12.61166,-4.57015z"></path></g></g></svg>';

    $note_icon = '<svg width="100%" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 172 172"><g fill="none" fill-rule="nonzero" stroke="none" stroke-width="1" stroke-linecap="butt" stroke-linejoin="miter" stroke-miterlimit="10" stroke-dasharray="" stroke-dashoffset="0" font-family="none" font-weight="none" font-size="none" text-anchor="none" style="mix-blend-mode: normal"><path d="M0,172v-172h172v172z" fill="none"></path><g fill="#8c8c8c"><path d="M60.83268,14.25635c-2.96578,0.04633 -5.33356,2.48615 -5.29101,5.45199v5.375h-10.75c-8.84188,0 -16.125,7.28312 -16.125,16.125v96.75c0,8.84188 7.28312,16.125 16.125,16.125h82.41667c8.84188,0 16.125,-7.28312 16.125,-16.125v-96.75c0,-8.84188 -7.28312,-16.125 -16.125,-16.125h-3.58333v10.75h3.58333c3.03329,0 5.375,2.34171 5.375,5.375v96.75c0,3.03329 -2.34171,5.375 -5.375,5.375h-82.41667c-3.03329,0 -5.375,-2.34171 -5.375,-5.375v-96.75c0,-3.03329 2.34171,-5.375 5.375,-5.375h10.75v5.375c-0.02741,1.93842 0.99102,3.74144 2.66532,4.71865c1.6743,0.97721 3.74507,0.97721 5.41937,0c1.6743,-0.97721 2.69273,-2.78023 2.66532,-4.71865v-21.5c0.02085,-1.45347 -0.54782,-2.85342 -1.57634,-3.88062c-1.02852,-1.0272 -2.4292,-1.59408 -3.88264,-1.57136zM85.91601,14.25635c-2.96578,0.04633 -5.33356,2.48615 -5.29101,5.45199v5.375h-7.16667v10.75h7.16667v5.375c-0.02741,1.93842 0.99102,3.74144 2.66532,4.71865c1.6743,0.97721 3.74507,0.97721 5.41937,0c1.6743,-0.97721 2.69273,-2.78023 2.66532,-4.71865v-21.5c0.02085,-1.45347 -0.54782,-2.85342 -1.57634,-3.88062c-1.02852,-1.0272 -2.4292,-1.59408 -3.88264,-1.57136zM110.99935,14.25635c-2.96578,0.04633 -5.33356,2.48615 -5.29101,5.45199v5.375h-7.16667v10.75h7.16667v5.375c-0.02741,1.93842 0.99102,3.74144 2.66532,4.71865c1.6743,0.97721 3.74507,0.97721 5.41937,0c1.6743,-0.97721 2.69273,-2.78023 2.66532,-4.71865v-21.5c0.02085,-1.45347 -0.54782,-2.85342 -1.57634,-3.88062c-1.02852,-1.0272 -2.4292,-1.59408 -3.88264,-1.57136zM59.125,60.91667c-1.93842,-0.02741 -3.74144,0.99102 -4.71865,2.66532c-0.97721,1.6743 -0.97721,3.74507 0,5.41937c0.97721,1.6743 2.78023,2.69273 4.71865,2.66532h53.75c1.93842,0.02741 3.74144,-0.99102 4.71865,-2.66532c0.97721,-1.6743 0.97721,-3.74507 0,-5.41937c-0.97721,-1.6743 -2.78023,-2.69273 -4.71865,-2.66532zM59.125,89.58333c-1.93842,-0.02741 -3.74144,0.99102 -4.71865,2.66532c-0.97721,1.6743 -0.97721,3.74507 0,5.41937c0.97721,1.6743 2.78023,2.69273 4.71865,2.66532h25.08333c1.93842,0.02741 3.74144,-0.99102 4.71865,-2.66532c0.97721,-1.6743 0.97721,-3.74507 0,-5.41937c-0.97721,-1.6743 -2.78023,-2.69273 -4.71865,-2.66532zM59.125,118.25c-1.93842,-0.02741 -3.74144,0.99102 -4.71865,2.66532c-0.97721,1.6743 -0.97721,3.74507 0,5.41937c0.97721,1.6743 2.78023,2.69273 4.71865,2.66532h39.41667c1.93842,0.02741 3.74144,-0.99102 4.71865,-2.66532c0.97721,-1.6743 0.97721,-3.74507 0,-5.41937c-0.97721,-1.6743 -2.78023,-2.69273 -4.71865,-2.66532z"></path></g></g></svg>';

    $download_icon = '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 172 172"><g fill="none" fill-rule="nonzero" stroke="none" stroke-width="1" stroke-linecap="butt" stroke-linejoin="miter" stroke-miterlimit="10" stroke-dasharray="" stroke-dashoffset="0" font-family="none" font-weight="none" font-size="none" text-anchor="none" style="mix-blend-mode: normal"><path d="M0,172v-172h172v172z" fill="none"></path><g fill="#000000"><path d="M143.78125,139.75v-26.875c0,-2.28437 -1.74687,-4.03125 -4.03125,-4.03125c-2.28438,0 -4.03125,1.74688 -4.03125,4.03125v22.84375h-99.4375v-22.84375c0,-2.28437 -1.74688,-4.03125 -4.03125,-4.03125c-2.28438,0 -4.03125,1.74688 -4.03125,4.03125v26.875c0,2.28438 1.74687,4.03125 4.03125,4.03125h107.5c2.28438,0 4.03125,-1.74687 4.03125,-4.03125zM86,28.21875c-2.28437,0 -4.03125,1.74687 -4.03125,4.03125v57.5125l-13.30312,-13.30313c-1.6125,-1.6125 -4.16563,-1.6125 -5.64375,0c-1.6125,1.6125 -1.6125,4.16563 0,5.64375l20.15625,20.15625c0.80625,0.80625 1.88125,1.20938 2.82188,1.20938c0.94062,0 2.01563,-0.40313 2.82187,-1.20938l20.15625,-20.15625c1.6125,-1.6125 1.6125,-4.16563 0,-5.64375c-1.6125,-1.6125 -4.16562,-1.6125 -5.64375,0l-13.30312,13.30313v-57.5125c0,-2.28438 -1.74688,-4.03125 -4.03125,-4.03125z"></path></g></g></svg>';

    $timecards = get_timecards_data();
    include "timecard-filter.php";
    if(!empty($timecards)){
        ?>

        <table class="table-striped table">
            <thead style="background-color: #f8f9fa">
            <tr>
                <th width="80">Date</th>
                <th>Clock In</th>
                <th>Clock Out</th>
                <th>Breaks (total)</th>
                <th>Job No</th>
                <th>Daily progress files</th>
                <th>Notes</th>
                <th>Total hours</th>
            </tr>
            </thead>
            <tbody>
            <?php
            function timeToSeconds($time)
            {
                $arr = explode(':', $time);
                if (count($arr) === 3) {
                    return $arr[0] * 3600 + $arr[1] * 60 + $arr[2];
                }
                return $arr[0] * 60 + $arr[1];
            }

            foreach($timecards as $idx=>$timecard){
                $logid = $timecard['log_id'];

                $upload_ids = [];
                $jobs = [];
                $total_uploads = 0;
                $job_files = [];
                $files_query = mysqli_query($conn,"SELECT upload.*, job.job_no FROM upload_dev AS upload JOIN job ON job.id=upload.job_id WHERE upload.clock_log_id=$logid GROUP BY upload.id");


                while($up_file = mysqli_fetch_array($files_query)) {
                    $jid = $up_file['job_no'];
                    if(!in_array($jid,$upload_ids)) {
                        $upload_ids[] = $jid;
                    }
                    $job_files[$jid][] = $up_file;
                    $total_uploads++;
                    $getJob = mysqli_fetch_assoc(mysqli_query($conn,"SELECT * FROM job WHERE id=$jid"));
                    if($getJob) {
                        $jobs[] = $getJob;
                    }
                }


                $breaks = mysqli_query($conn,"SELECT * FROM employee_break_log WHERE log_id='$logid' ORDER BY break_id DESC");
                $break_total = new DateTime('0000-01-01 00:00:00');

                $break_log = [];
                if($breaks->num_rows) {
                    while($break = mysqli_fetch_array($breaks)) {
                        $time_format = time_difference($break['break_in'],$break['break_out']);
                        $h = $time_format->format('H');
                        $i = $time_format->format('i');
                        $s = $time_format->format('s');

                        $total_time = date('h:i a',strtotime($break['break_in'])).' - '.date('h:i a',strtotime($break['break_out']));

                        $break_log[] = ['break_id'=>$break['break_id'],'in'=>$break['break_in'], 'out'=>$break['break_out'], 'total'=>$total_time];

                        $break_total->add(new DateInterval("PT$h"."H$i"."M$s"."S"));
                    }
                }


                $clock_in = new DateTime($timecard['clock_in']);
                $clock_out = new DateTime($timecard['clock_out']);

                $diff_diff = $clock_out->diff($clock_in);

                $h = $diff_diff->h > 9 ? $diff_diff->h : '0'.$diff_diff->h;
                $i = $diff_diff->i > 9 ? $diff_diff->i : '0'.$diff_diff->i;
                $s = $diff_diff->s > 9 ? $diff_diff->s : '0'.$diff_diff->s;

                $total_hrs = $h.':'.$i.':'.$s;

                $total_time_diff = ($diff_diff->h*(60*60)) + ($diff_diff->i*60) + $diff_diff->s;
                //$total_time_diff = $diff_diff->h.':'.$diff_diff->i.':'.$diff_diff->s;
                ?>
                <tr>
                    <td width="80"><?php echo date('d/m/Y',strtotime($timecard['record_date'])) ?></td>
                    <td><?php echo ($timecard['clock_in']) ?></td>
                    <td><?php echo ($timecard['clock_out']) ?></td>
                    <td>
                        <div class="text-tooltip">
                            <div class="text"><?php echo !$breaks->num_rows ? 'No break' : $break_total->format('H:i:s') ?></div>
                            <?php if($breaks->num_rows) {
                                ?>
                                <div class="tooltip">
                                    <?php foreach($break_log as $log) {
                                        ?>
                                        <div><?php echo $log['total'] ?></div>
                                        <?php
                                    }?>
                                </div>
                                <?php
                            }?>
                        </div>
                    </td>
                    <td><?php echo implode(', ',$upload_ids) ?></td>
                    <td>
                        <div data-id="progress_files_<?php echo $logid ?>" style="width: 24px" class="link swal_popup"><?php echo $folder_icon ?></div>

                        <div id="progress_files_<?php echo $logid ?>" class="file-progress-model hidden">
                            <h3>DAILY PROGRESS FILES</h3>
                            <div class="time-meta">
                                <div> <strong>Date: </strong>  <?php echo date('D d F Y',strtotime($timecard['record_date'])) ?></div>
                                <div>  <strong>Total uploads: </strong> <?php echo $total_uploads ?></div>
                            </div>
                            <div class="job-file-list">
                                <div class="job-group">
                                    <?php
                                    foreach($job_files as $files){ ?>
                                        <div style="border: 1px dashed #eee;padding: 0 10px;margin-bottom: 1em;">
                                            <h3>Job no. <?php echo $jid ?> &nbsp; <span class="file-count"><?php echo count($files) ?> file<?php echo count($files) > 1 ? 's':'' ?></span></h3>
                                            <?php foreach($files as $file){
                                                $file_name = explode('__',$file['file_name'])[1];
                                                $file_size = $file['file_size'];
                                                $url = 'timecards/uploads/'.$file['file_name'];
                                                ?>
                                                <div class="file-list">
                                                    <div style="width: 90%">
                                                        <div class="file-icon"><?php echo $note_icon ?></div>
                                                        <label><a target="_blank" href="<?php echo $url ?>"><?php echo $file_name; ?></a></label>
                                                        <p class="file-size"><?php echo get_file_size($file_size) ?></p>
                                                    </div>
                                                    <div>
                                                        <a target="_blank" href="<?php echo $url ?>" class="download-btn"><i class="icon-download"><?php echo $download_icon; ?></i> </a>
                                                    </div>
                                                </div>
                                            <?php }?>
                                        </div>
                                    <?php }?>
                                </div>
                            </div>
                        </div>
                    </td>
                    <td><div style="width: 24px" class="link" onclick="">

                           <?php
                           $note = $timecard['note'];
                           if(!empty($note)){
                           ?>
                            <div class="text-tooltip">
                                <div class="text"><?php echo $note_icon ?></div>
                                <div class="tooltip">
                                    <div style="width: 100%;"><?php echo ($note); ?></div>
                                </div>
                            </div>
                            <?php }else {
                               ?>
                            <div style="opacity: 0.5; pointer-events: none"> <?php echo $note_icon ?></div>
                                <?php
                           }?>
                        </div>
                    </td>
                    <td><?php echo $total_hrs ?></td>
                </tr>
            <?php }?>
            </tbody>
        </table>
    <?php }else {
        ?>
        <h2 class="not-found">No record found</h2>
        <?php
    }?>
</div>

<script type="text/javascript">
    jQuery(function() {
        $('select.select2').select2();
    })
</script>

<script type="application/javascript" src="timecards/js/timecards.js"></script>

<footer>
    <?php include('../includes/footer.php');?>
</footer>
</body>
</html>